<?php

add_action('init','of_options');

if (!function_exists('of_options')) {
function of_options(){

/* 	Shortnames
	================================================= */
	$shortname = THEMEPREFIX;
	$themename = THEMENAME;

/* 	File Paths
	================================================= */
	$bgurl 		=  get_template_directory_uri() . '/images/bg/';
	$bgheadurl 	=  get_template_directory_uri() . '/images/header/';
	$defurl 	=  get_template_directory_uri() . '/images/defaults/';

/*	Start Admin Options 
	================================================= */
	$options = array();


/*	General
	================================================= */

	$options[] = array( "name" => __('General','CURLYTHEME'),
						"type" => "heading");
						
	$options[] = array( "name" => __('Site Name','CURLYTHEME'),
				"desc" => __("Don't have a logo? No Problem just type your website name", 'CURLYTHEME'),
				"id" => $shortname."_title",
				"std" => get_bloginfo('name'),
				"type" => "text");
				
	$options[] = array( "name" => __('Site Logo','CURLYTHEME'),
				"desc" => __('Maximum width is 520px, but don\'t worry, this is responsive anyway','CURLYTHEME'),
				'class' => 'split_50',
				"id" => $shortname."_logo",
				"std" => $defurl.'equestrian-logo.png',
				"type" => "upload");					
	
	$options[] = array( "name" => __('Favicon Upload','CURLYTHEME'),
				"desc" => __("Upload 16px * 16px favicon", 'CURLYTHEME'),
				"id" => $shortname."_general_favicon",
				'class' => 'split_50 last',
				"std" => $defurl.'equestrian-favicon.png',
				"type" => "upload");	
						
	$options[] = array( "name" => __('Website Layout Style (Wide / Boxed Version)','CURLYTHEME'),
				"desc" => __("Check this if you want your website to be wide. If not checked website will be boxed", 'CURLYTHEME'),
				"id" => $shortname."_general_wide",
				'class' => 'split_50 section_clear_left',
				"std" => "true",
				"type" => "checkbox");
	
	$options[] = array( "name" => __('Website Layout Position','CURLYTHEME'),
				"desc" => __("Check this if you want your website to be aligned to the left side of the screen. <strong>NOTE: This option is only available if the Website Layout Style is set to Boxed.</strong>", 'CURLYTHEME'),
				"id" => $shortname."_general_align",
				'class' => 'split_50 split_right',
				"std" => "false",
				"type" => "checkbox");			
	
	$options[] = array( "name" => __('Website Responsive Layout','CURLYTHEME'),
				"desc" => __("Check this if you want your website to be responsive (Recommended). Responsive layout is a web design approach aimed at crafting sites to provide an optimal viewing experience, easy reading and navigation with a minimum of resizing, panning, and scrolling across a wide range of devices (from mobile phones to desktop computer monitors).", 'CURLYTHEME'),
				"id" => $shortname."_general_responsive",
				"std" => "true",
				"type" => "checkbox");
	
	$options[] = array( "name" => __('Contact Form Email Address','CURLYTHEME'),
				"desc" => __("All contact enquiries will be sent to this email. <strong>Note:</strong> if empty, the contact form will be disabled", 'CURLYTHEME'),
				"id" => $shortname."_general_email",
				"std" => null,
				"type" => "text");						
	
	$options[] = array( "name" => __('Hide Sharing Box on Pages','CURLYTHEME'),
				"desc" => __("Check this if you want to hide the sharing box on normal pages. Default is checked", 'CURLYTHEME'),
				"id" => $shortname."_general_sharing_box_pages",
				'class' => 'split_50 section_clear_left',
				"std" => "true",
				"type" => "checkbox");	
	
	$options[] = array( "name" => __('Sharing Box Title','CURLYTHEME'),
				"desc" => __("This text is used in the sharing box, before the icons", 'CURLYTHEME'),
				"id" => $shortname."_general_sharing_box_text",
				'class' => 'split_50 last',
				"std" => "Share us! Choose you social Network",
				"type" => "text");	
	
	$options[] = array( "name" => __('404 Page Content','CURLYTHEME'),
				"desc" => __("This text is used in the 404 Page. Shortcodes are accepted.", 'CURLYTHEME'),
				"id" => $shortname."_404_text",
				'class' => 'full_textarea',
				"std" => "",
				"type" => "textarea");								



/*	Header
	================================================= */	

	$options[] = array( "name" => __('Header','CURLYTHEME'),
						"type" => "heading");
	
	$options[] = array( "name" => __('Header / Margin Top','CURLYTHEME'),
				"desc" => __("px. Default value: 55px", 'CURLYTHEME'),
				"id" => $shortname."_header_margin_top",
				"class" => "split_50 small_input",
				"std" => "55",
				"type" => "text");
	
	$options[] = array( "name" => __('Header / Margin Bottom','CURLYTHEME'),
				"desc" => __("px. Default value: 75px", 'CURLYTHEME'),
				"id" => $shortname."_header_margin_bottom",
				"class" => "split_50 split_right small_input",
				"std" => "75",
				"type" => "text");
	
	$options[] = array( "name" => __('Header Shading Color','CURLYTHEME'),
				"desc" => __("Header Shading Color", 'CURLYTHEME'),
				"id" => $shortname."_header_shading_color",
				"class" => "split_50 color_float",
				"std" => "#000000",
				"type" => "color");			
	
	$options[] = array( "name" => __('Header Shading Opacity','CURLYTHEME'),
				"desc" => __("%. Default value: 55%. (Range: 0 - 100)", 'CURLYTHEME'),
				"id" => $shortname."_header_shading_opacity",
				"class" => "split_50 split_right small_input",
				"std" => "55",
				"type" => "text");
	
	$options[] = array( "name" => __('Background Shading Pattern','CURLYTHEME'),
				"desc" => __('Are you feeling creative? Choose your own shading pattern. ','CURLYTHEME'),
				"id" => $shortname."_header_shading_pattern",
				"std" => "1",
				"type" => "images",
				"options" => array(
					0 	=> $bgheadurl . 'btn-bg-00.png',
					1 	=> $bgheadurl . 'btn-bg-01.png',
					2 	=> $bgheadurl . 'btn-bg-02.png',
					3 	=> $bgheadurl . 'btn-bg-03.png',
					4 	=> $bgheadurl . 'btn-bg-04.png'
					));				
				
	$options[] = array( "name" => __('Header Texts / Left Text','CURLYTHEME'),
				"id" => $shortname."_header_1st_text_line",
				"desc" => __('Shortcodes can be used','CURLYTHEMES'),
				"class" => "split_50",
				"std" => "",
				"type" => "text");
	
	$options[] = array( "name" => __('Header Texts / Right Text','CURLYTHEME'),
				"id" => $shortname."_header_2nd_text_line",
				"desc" => __('Shortcodes can be used','CURLYTHEMES'),
				"class" => "split_50 split_right",
				"std" => "",
				"type" => "text");
	
	$options[] = array( "name" => __('Disable Sticky Menu','CURLYTHEME'),
				"desc" => __("Disable sticky menu" , 'CURLYTHEME'),
				"id" => $shortname."_sticky_menu",
				"class" => "split_50",
				"std" => "false",
				"type" => "checkbox");
	
	$options[] = array( "name" => __('Disable Menu Hover','CURLYTHEME'),
				"desc" => __("Disable menu hover effect (dark shading)" , 'CURLYTHEME'),
				"id" => $shortname."_hover_menu",
				"class" => "split_50 split_right",
				"std" => "false",
				"type" => "checkbox");
							

/*	Footer
	================================================= */

	$options[] = array( "name" => __('Footer','CURLYTHEME'),
						"type" => "heading");
						
	$options[] = array( "name" => __('Disable Footer','CURLYTHEME'),
				"desc" => __('Disable footer' , 'CURLYTHEME'),
				"id" => $shortname."_footer",
				'class' => 'split_50',
				"std" => "false",
				"type" => "checkbox");
	
	$options[] = array( "name" => __('Disable Absolute Footer','CURLYTHEME'),
				"desc" => __("Disable absolute footer" , 'CURLYTHEME'),
				"id" => $shortname."_absolute_footer",
				'class' => 'split_50 last',
				"std" => "false",
				"type" => "checkbox");					
	
	$options[] = array( "name" => __('Footer Top Margin','CURLYTHEME'),
				"desc" => __("px. Default is 40px", 'CURLYTHEME'),
				"id" => $shortname."_footer_margin",
				"class" => "split_50 small_input",
				"std" => "40",
				"type" => "text");
	
	$options[] = array( "name" => __('Footer Bottom Margin','CURLYTHEME'),
				"desc" => __("px. Default is 60px", 'CURLYTHEME'),
				"id" => $shortname."_footer_margin_bottom",
				"class" => "split_50 split_right small_input",
				"std" => "60",
				"type" => "text");
	
	$options[] = array( "name" => __('Footer Logo','CURLYTHEME'),
				"desc" => __('Max. width is 200px, but be cool, this is responsive anyway','CURLYTHEME'),
				"id" => $shortname."_logo_footer",
				"class" => "split_50",
				"type" => "upload");

	$options[] = array( "name" => __('Footer Background Color','CURLYTHEME'),
				"id" => $shortname."_footer_bg_color",
				"class" => "color_float split_50 split_right",
				"std" => "",
				"type" => "color");									
	
	$options[] = array( "name" => __('Background Image','CURLYTHEME'),
				"desc" => __("Upload image and use it as background of the website", 'CURLYTHEME'),
				"id" => $shortname."_bg_footer_image",
				"std" => "",
				"type" => "upload");			
	
	$options[] = array( "name" => __('Background Image Repeat','CURLYTHEME'),
				"desc" => __('Background image tile method','CURLYTHEME'),
				"id" => $shortname."_bg_footer_repeat",
				"class" => "split_50",
				"std" => "no-repeat",
				"type" => "select",
				"options" => array(
					'no-repeat' => 'No Repeat',
					'repeat' => 'Repeat',
					'repeat-x' => 'Repeat Horizontaly',
					'repeat-y' => 'Repeat Verticaly',
					));
	
	$options[] = array( "name" => __('Background Image Position','CURLYTHEME'),
				"id" => $shortname."_bg_footer_position",
				"class" => "split_50 split_right",
				"std" => "left top",
				"type" => "select",
				"options" => array(
					'left top' => 'Top Left',
					'center top' => 'Top Center',
					'right top' => 'Top Right', 
					'left center' => 'Middle Left',
					'center center' => 'Middle Center',
					'right center' => 'Middle Right',
					'left bottom' => 'Bottom Left',
					'center bottom' => 'Bottom Center',
					'right bottom' => 'Bottom Right'));								

/*	Background
	================================================= */
					
	$options[] = array( "name" => __('Background','CURLYTHEME'),
						"type" => "heading");
	
	$options[] = array( "name" => __('Website Background Color','CURLYTHEME'),
				"desc" => __("Background color of the website", 'CURLYTHEME'),
				"id" => $shortname."_bg_color",
				"class" => "color_float",
				"std" => "#faf6f0",
				"type" => "color");
	
	$options[] = array( "name" => __('Background Pattern','CURLYTHEME'),
				"desc" => __('Are you feeling creative? Choose your own background pattern. <br><br><strong>NOTE:</strong> Choosing a background pattern will override all other background settings except individual page settings.','CURLYTHEME'),
				"id" => $shortname."_bg_pattern",
				"std" => "11",
				"type" => "images",
				"options" => array(
					0 	=> $bgurl . 'btn-bg-00.png',
					1 	=> $bgurl . 'btn-bg-01.png',
					2 	=> $bgurl . 'btn-bg-02.png',
					3 	=> $bgurl . 'btn-bg-03.png',
					4 	=> $bgurl . 'btn-bg-04.png',
					5 	=> $bgurl . 'btn-bg-05.png',
					6 	=> $bgurl . 'btn-bg-06.png',
					7 	=> $bgurl . 'btn-bg-07.png',
					8 	=> $bgurl . 'btn-bg-08.png',
					9 	=> $bgurl . 'btn-bg-09.png',
					10 	=> $bgurl . 'btn-bg-10.png',
					11 	=> $bgurl . 'btn-bg-11.jpg'
					));	
				
	$options[] = array( "name" => __('Background Image','CURLYTHEME'),
				"desc" => __("Upload image and use it as background of the website", 'CURLYTHEME'),
				"id" => $shortname."_bg_image",
				"std" => "",
				"type" => "upload");			
	
	$options[] = array( "name" => __('Background Image Repeat','CURLYTHEME'),
				"desc" => __('Background image tile method','CURLYTHEME'),
				"id" => $shortname."_bg_repeat",
				"class" => "split_50",
				"std" => "no-repeat",
				"type" => "select",
				"options" => array(
					'no-repeat' => 'No Repeat',
					'repeat' => 'Repeat',
					'repeat-x' => 'Repeat Horizontaly',
					'repeat-y' => 'Repeat Verticaly',
					));
	
	$options[] = array( "name" => __('Background Image Position','CURLYTHEME'),
				"id" => $shortname."_bg_position",
				"class" => "split_50 split_right",
				"std" => "left top",
				"type" => "select",
				"options" => array(
					'left top' => 'Top Left',
					'center top' => 'Top Center',
					'right top' => 'Top Right', 
					'left center' => 'Middle Left',
					'center center' => 'Middle Center',
					'right center' => 'Middle Right',
					'left bottom' => 'Bottom Left',
					'center bottom' => 'Bottom Center',
					'right bottom' => 'Bottom Right'));				
	
	$options[] = array( "name" => __('Background Image is Fixed','CURLYTHEME'),
				"desc" => __('Check this if you want the background image to be fixed','CURLYTHEME'),
				"id" => $shortname."_bg_fixed",
				"class" => "split_50 section_clear_left",
				"std" => "false",
				"type" => "checkbox");		

/*	Typography
	================================================= */
	
	$options[] = array( "name" => __('Typography','CURLYTHEME'),
						"type" => "heading");
	
	$options[] = array( "name" => __('General Font (all texts)','CURLYTHEME'),
				"desc" => __('Use our cool Font Viewer.  <a href="'.get_template_directory_uri() .'/admin/font-preview.html?KeepThis=true&TB_iframe=true&height=400&width=600" class="thickbox" title="Font Viewer">Open Font Viewer</a>','CURLYTHEME'),
				"id" => $shortname."_fonts_body",
				"class" => "split_50",
				"std" => "29",
				"type" => "select",
				"options" => curly_get_fonts());
	
	$options[] = array( "name" => __('General Font Size','CURLYTHEME'),
				"desc" => __("Select a font size value ",'CURLYTHEME'),
				"id" => $shortname."_fonts_size_body",
				"class" => "split_50 split_right",
				"std" => "14",
				"type" => "select",
				"options" => curly_get_font_sizes(10,18));
	
	$options[] = array( "name" => __('General Font Style','CURLYTHEME'),
				"desc" => __('Choose the font style','CURLYTHEME'),
				"id" => $shortname."_fonts_style_body",
				"class" => "split_50 section_clear_left",
				"std" => "0",
				"type" => "select",
				"options" => array('Light', 'Light Italic', 'Normal', 'Bold', 'Italic', 'Bold Italic'));		
	
	$options[] = array( "name" => __('Include Special Characters','CURLYTHEME'),
				"desc" => __('Subsets for languages with special characters.','CURLYTHEME'),
				"id" => $shortname."_fonts_subset",
				"class" => "split_50 split_right",
				"std" => "0",
				"type" => "select",
				"options" => array('No Subset - Standard Latin','Cyrillic Extended (cyrillic-ext)', 'Greek Extended (greek-ext)', 'Greek (greek)', 'Vietnamese (vietnamese)' , 'Latin Extended (latin-ext)' , 'Cyrillic (cyrillic)'));
	
	$options[] = array( "name" => __('H1','CURLYTHEME'),
				"id" => $shortname."_inf",
				"std" => "H1 Heading Typography",
				"type" => "info");
	
	$options[] = array( "name" => __('H1 Heading Font','CURLYTHEME'),
				"desc" => __('Use our cool Font Viewer <a href="'.get_template_directory_uri() .'/admin/font-preview.html?KeepThis=true&TB_iframe=true&height=400&width=600" class="thickbox" title="Font Viewer">Open Font Viewer</a>','CURLYTHEME'),
				"id" => $shortname."_fonts_h1",
				"class" => "split_50",
				"std" => "53",
				"type" => "select",
				"options" => curly_get_fonts());
	
	$options[] = array( "name" => __('H1 Heading Font Size','CURLYTHEME'),
				"id" => $shortname."_fonts_size_h1",
				"class" => "split_50 split_right",
				"std" => "36",
				"type" => "select",
				"options" => curly_get_font_sizes(30,68));
	
	$options[] = array( "name" => __('H1 Heading Font Style','CURLYTHEME'),
				"id" => $shortname."_fonts_style_h1",
				"class" => "split_50 section_clear_left",
				"std" => "3",
				"type" => "select",
				"options" => array('Light', 'Light Italic', 'Normal', 'Bold', 'Italic', 'Bold Italic'));
	
	$options[] = array( "name" => __('H1 Heading Font Variant','CURLYTHEME'),
				"id" => $shortname."_fonts_variant_h1",
				"class" => "split_50 split_right",
				"std" => "0",
				"type" => "select",
				"options" => array('Normal', 'Capitalize', 'Uppercase', 'Small Caps'));
	
	$options[] = array( "name" => __('H2','CURLYTHEME'),
				"id" => $shortname."_inf",
				"std" => "H2 Heading Typography",
				"type" => "info");
	
	$options[] = array( "name" => __('H2 Heading Font','CURLYTHEME'),
				"desc" => __('Use our cool Font Viewer <a href="'.get_template_directory_uri() .'/admin/font-preview.html?KeepThis=true&TB_iframe=true&height=400&width=600" class="thickbox" title="Font Viewer">Open Font Viewer</a>','CURLYTHEME'),
				"id" => $shortname."_fonts_h2",
				"class" => "split_50",
				"std" => "53",
				"type" => "select",
				"options" => curly_get_fonts());
	
	$options[] = array( "name" => __('H2 Heading Font Size','CURLYTHEME'),
				"id" => $shortname."_fonts_size_h2",
				"class" => "split_50 split_right",
				"std" => "36",
				"type" => "select",
				"options" => curly_get_font_sizes(20,58));
	
	$options[] = array( "name" => __('H2 Heading Font Style','CURLYTHEME'),
				"id" => $shortname."_fonts_style_h2",
				"class" => "split_50 section_clear_left",
				"std" => "0",
				"type" => "select",
				"options" => array('Light', 'Light Italic', 'Normal', 'Bold', 'Italic', 'Bold Italic'));
	
	$options[] = array( "name" => __('H2 Heading Font Variant','CURLYTHEME'),
				"id" => $shortname."_fonts_variant_h2",
				"class" => "split_50 split_right",
				"std" => "0",
				"type" => "select",
				"options" => array('Normal', 'Capitalize', 'Uppercase', 'Small Caps'));
	
	$options[] = array( "name" => __('H3','CURLYTHEME'),
				"id" => $shortname."_inf",
				"std" => "H3 Heading Typography",
				"type" => "info");
	
	$options[] = array( "name" => __('H3 Heading Font','CURLYTHEME'),
				"desc" => __('Use our cool Font Viewer <a href="'.get_template_directory_uri() .'/admin/font-preview.html?KeepThis=true&TB_iframe=true&height=400&width=600" class="thickbox" title="Font Viewer">Open Font Viewer</a>','CURLYTHEME'),
				"id" => $shortname."_fonts_h3",
				"class" => "split_50",
				"std" => "53",
				"type" => "select",
				"options" => curly_get_fonts());
	
	$options[] = array( "name" => __('H3 Heading Font Size','CURLYTHEME'),
				"id" => $shortname."_fonts_size_h3",
				"class" => "split_50 split_right",
				"std" => "24",
				"type" => "select",
				"options" => curly_get_font_sizes(15,48));
	
	$options[] = array( "name" => __('H3 Heading Font Style','CURLYTHEME'),
				"id" => $shortname."_fonts_style_h3",
				"class" => "split_50 section_clear_left",
				"std" => "3",
				"type" => "select",
				"options" => array('Light', 'Light Italic', 'Normal', 'Bold', 'Italic', 'Bold Italic'));
	
	$options[] = array( "name" => __('H3 Heading Font Variant','CURLYTHEME'),
				"id" => $shortname."_fonts_variant_h3",
				"class" => "split_50 split_right",
				"std" => "0",
				"type" => "select",
				"options" => array('Normal', 'Capitalize', 'Uppercase', 'Small Caps'));
				
	$options[] = array( "name" => __('H4','CURLYTHEME'),
				"id" => $shortname."_inf",
				"std" => "H4 Heading Typography",
				"type" => "info");
	
	$options[] = array( "name" => __('H4 Heading Font','CURLYTHEME'),
				"desc" => __('Use our cool Font Viewer <a href="'.get_template_directory_uri() .'/admin/font-preview.html?KeepThis=true&TB_iframe=true&height=400&width=600" class="thickbox" title="Font Viewer">Open Font Viewer</a>','CURLYTHEME'),
				"id" => $shortname."_fonts_h4",
				"class" => "split_50",
				"std" => "53",
				"type" => "select",
				"options" => curly_get_fonts());
	
	$options[] = array( "name" => __('H4 Heading Font Size','CURLYTHEME'),
				"id" => $shortname."_fonts_size_h4",
				"class" => "split_50 split_right",
				"std" => "18",
				"type" => "select",
				"options" => curly_get_font_sizes(14,30));
	
	$options[] = array( "name" => __('H4 Heading Font Style','CURLYTHEME'),
				"id" => $shortname."_fonts_style_h4",
				"class" => "split_50 section_clear_left",
				"std" => "2",
				"type" => "select",
				"options" => array('Light', 'Light Italic', 'Normal', 'Bold', 'Italic', 'Bold Italic'));
	
	$options[] = array( "name" => __('H4 Heading Font Variant','CURLYTHEME'),
				"id" => $shortname."_fonts_variant_h4",
				"class" => "split_50 split_right",
				"std" => "2",
				"type" => "select",
				"options" => array('Normal', 'Capitalize', 'Uppercase', 'Small Caps'));	
	
	$options[] = array( "name" => __('H5','CURLYTHEME'),
				"id" => $shortname."_inf",
				"std" => "H5 Heading Typography",
				"type" => "info");
	
	$options[] = array( "name" => __('H5 Heading Font','CURLYTHEME'),
				"desc" => __('Use our cool Font Viewer <a href="'.get_template_directory_uri() .'/admin/font-preview.html?KeepThis=true&TB_iframe=true&height=400&width=600" class="thickbox" title="Font Viewer">Open Font Viewer</a>','CURLYTHEME'),
				"id" => $shortname."_fonts_h5",
				"class" => "split_50",
				"std" => "53",
				"type" => "select",
				"options" => curly_get_fonts());
	
	$options[] = array( "name" => __('H5 Heading Font Size','CURLYTHEME'),
				"id" => $shortname."_fonts_size_h5",
				"class" => "split_50 split_right",
				"std" => "15",
				"type" => "select",
				"options" => curly_get_font_sizes(14,30));
	
	$options[] = array( "name" => __('H5 Heading Font Style','CURLYTHEME'),
				"id" => $shortname."_fonts_style_h5",
				"class" => "split_50 section_clear_left",
				"std" => "3",
				"type" => "select",
				"options" => array('Light', 'Light Italic', 'Normal', 'Bold', 'Italic', 'Bold Italic'));
	
	$options[] = array( "name" => __('H5 Heading Font Variant','CURLYTHEME'),
				"id" => $shortname."_fonts_variant_h5",
				"class" => "split_50 split_right",
				"std" => "0",
				"type" => "select",
				"options" => array('Normal', 'Capitalize', 'Uppercase', 'Small Caps'));		
	
	$options[] = array( "name" => __('H6','CURLYTHEME'),
				"id" => $shortname."_inf",
				"std" => "H6 Heading Typography",
				"type" => "info");
	
	$options[] = array( "name" => __('H6 Heading Font','CURLYTHEME'),
				"desc" => __('Use our cool Font Viewer <a href="'.get_template_directory_uri() .'/admin/font-preview.html?KeepThis=true&TB_iframe=true&height=400&width=600" class="thickbox" title="Font Viewer">Open Font Viewer</a>','CURLYTHEME'),
				"id" => $shortname."_fonts_h6",
				"class" => "split_50",
				"std" => "53",
				"type" => "select",
				"options" => curly_get_fonts());
	
	$options[] = array( "name" => __('H6 Heading Font Size','CURLYTHEME'),
				"id" => $shortname."_fonts_size_h6",
				"class" => "split_50 split_right",
				"std" => "15",
				"type" => "select",
				"options" => curly_get_font_sizes(14,24));
	
	$options[] = array( "name" => __('H6 Heading Font Style','CURLYTHEME'),
				"id" => $shortname."_fonts_style_h6",
				"class" => "split_50 section_clear_left",
				"std" => "3",
				"type" => "select",
				"options" => array('Light', 'Light Italic', 'Normal', 'Bold', 'Italic', 'Bold Italic'));
	
	$options[] = array( "name" => __('H6 Heading Font Variant','CURLYTHEME'),
				"id" => $shortname."_fonts_variant_h6",
				"class" => "split_50 split_right",
				"std" => "0",
				"type" => "select",
				"options" => array('Normal', 'Capitalize', 'Uppercase', 'Small Caps'));						
	
	$options[] = array( "name" => __('Other','CURLYTHEME'),
				"id" => $shortname."_inf",
				"std" => "Other Typography",
				"type" => "info");
	
	$options[] = array( "name" => __('Menu Font','CURLYTHEME'),
				"desc" => __('Use our cool Font Viewer <a href="'.get_template_directory_uri() .'/admin/font-preview.html?KeepThis=true&TB_iframe=true&height=400&width=600" class="thickbox" title="Font Viewer">Open Font Viewer</a>','CURLYTHEME'),
				"id" => $shortname."_fonts_menu",
				"class" => "split_50",
				"std" => "53",
				"type" => "select",
				"options" => curly_get_fonts());
	
	$options[] = array( "name" => __('Blockquotes Font','CURLYTHEME'),
				"desc" => __('Use our cool Font Viewer <a href="'.get_template_directory_uri() .'/admin/font-preview.html?KeepThis=true&TB_iframe=true&height=400&width=600" class="thickbox" title="Font Viewer">Open Font Viewer</a>','CURLYTHEME'),
				"id" => $shortname."_fonts_blockquotes",
				"class" => "split_50 split_right",
				"std" => "29",
				"type" => "select",
				"options" => curly_get_fonts());
	
	$options[] = array( "name" => __('Menu Font Size','CURLYTHEME'),
				"id" => $shortname."_fonts_size_menu",
				"class" => "split_50",
				"std" => "16",
				"type" => "select",
				"options" => curly_get_font_sizes(10,20));
	
	$options[] = array( "name" => __('Upload Custom Fonts - Needs page refresh after upload','CURLYTHEME'),
				"desc" => __('Before the custom font to be activated you need to upload all formats','CURLYTHEMES'),
				"id" => $shortname."_inf",
				"std" => "Upload Custom Fonts - Needs page refresh after upload",
				"type" => "info");
	
	$options[] = array( "name" => __('Custom Fonts - .woff','CURLYTHEME'),
				"desc" => __('Upload font file .woff','CURLYTHEME'),
				"id" => $shortname."_font_upload_woff",
				"class" => "split_50",
				"type" => "upload_min");
	
	$options[] = array( "name" => __('Custom Fonts - .ttf','CURLYTHEME'),
				"desc" => __('Upload font file .ttf','CURLYTHEME'),
				"id" => $shortname."_font_upload_ttf",
				"class" => "split_50 split_right",
				"type" => "upload_min");			
	
	$options[] = array( "name" => __('Custom Fonts - .svg','CURLYTHEME'),
				"desc" => __('Upload font file .svg','CURLYTHEME'),
				"id" => $shortname."_font_upload_svg",
				"class" => "split_50",
				"type" => "upload_min");
	
	$options[] = array( "name" => __('Custom Fonts - .eot','CURLYTHEME'),
				"desc" => __('Upload font file .eot','CURLYTHEME'),
				"id" => $shortname."_font_upload_eot",
				"class" => "split_50 split_right",
				"type" => "upload_min");


/*	Colors
	================================================= */

	$options[] = array( "name" => __('Colors','CURLYTHEME'),
						"type" => "heading");
	
	$options[] = array( "name" => __('Predefined Color Schemes','CURLYTHEME'),
				"desc" => __('Choose a color scheme that you prefer','CURLYTHEME'),
				"id" => $shortname."_color_scheme",
				"std" => 'default',
				"type" => "select",
				"options" => array(
					'default' => 'Red (default)',
					'style1'  => 'Blue',
					'style2'  => 'Green',
					'style3'  => 'Amethyst',
					'style4'  => 'Orange',
					'style5'  => 'Royal Blue'
					));
					
	$options[] = array( "name" => __('Text Color','CURLYTHEME'),
				"desc" => "Text main color",
				"id" => $shortname."_color_text",
				"class" => "split_50",
				"std" => "#1E1E1E",
				"type" => "color");
				
	$options[] = array( "name" => __('Primary Color','CURLYTHEME'),
				"desc" => "Theme main color",
				"id" => $shortname."_color_primary",
				"class" => "split_50 last",
				"std" => "#c0392b",
				"type" => "color");		
	
	$options[] = array( "name" => __('Hiperlinks','CURLYTHEME'),
				"desc" => "",
				"id" => $shortname."_inf",
				"std" => "Hyperlinks",
				"type" => "info");
	
	$options[] = array( "name" => __('General Link Color','CURLYTHEME'),
				"desc" => __("Text link color", 'CURLYTHEME'),
				"id" => $shortname."_color_links",
				"class" => "split_50 color_float",
				"std" => "#c0392b",
				"type" => "color");
	
	$options[] = array( "name" => __('General Hover Link Color','CURLYTHEME'),
				"desc" => __("Text link hover color",'CURLYTHEME'),
				"id" => $shortname."_color_links_hover",
				"class" => "split_50 split_right color_float",
				"std" => "#1E1E1E",
				"type" => "color");			
	
	$options[] = array( "name" => __('Heading Colors H1 - H6, except Page Heading H1','CURLYTHEME'),
				"desc" => "",
				"id" => $shortname."_inf",
				"std" => "Heading Colors H1 - H6",
				"type" => "info");
	
	$options[] = array( "name" => __('H1 Titles','CURLYTHEME'),
				"id" => $shortname."_color_h1",
				"class" => "split_three",
				"std" => "#1E1E1E",
				"type" => "color");
	
	$options[] = array( "name" => __('H2 Titles','CURLYTHEME'),
				"id" => $shortname."_color_h2",
				"class" => "split_three",
				"std" => "#1E1E1E",
				"type" => "color");
	
	$options[] = array( "name" => __('H3 Titles','CURLYTHEME'),
				"id" => $shortname."_color_h3",
				"class" => "split_three last ",
				"std" => "#1E1E1E",
				"type" => "color");
	
	$options[] = array( "name" => __('H4 Titles','CURLYTHEME'),
				"id" => $shortname."_color_h4",
				"class" => "split_three",
				"std" => "#1E1E1E",
				"type" => "color");
				
	$options[] = array( "name" => __('H5 Titles','CURLYTHEME'),
				"id" => $shortname."_color_h5",
				"class" => "split_three",
				"std" => "#1E1E1E",
				"type" => "color");
	
	$options[] = array( "name" => __('H6 Titles','CURLYTHEME'),
				"id" => $shortname."_color_h6",
				"class" => "split_three last",
				"std" => "#1E1E1E",
				"type" => "color");
	
	$options[] = array( "name" => __('Header - Menu Colors','CURLYTHEME'),
				"desc" => "",
				"id" => $shortname."_inf",
				"std" => "Menu Colors",
				"type" => "info");
	
	$options[] = array( "name" => __('Menu Link Color','CURLYTHEME'),
				"id" => $shortname."_color_menu_text",
				"class" => "split_three",
				"std" => "#FFFFFF",
				"type" => "color");
	
	$options[] = array( "name" => __('Menu Link Hover Color','CURLYTHEME'),
				"id" => $shortname."_color_menu_hover_text",
				"class" => "split_three",
				"std" => "#E09C95",
				"type" => "color");
	
	$options[] = array( "name" => __('Menu Background Color','CURLYTHEME'),
				"id" => $shortname."_color_menu_bg_top",
				"class" => "split_three last",
				"std" => "#C0392B",
				"type" => "color");
	
	$options[] = array( "name" => __('Submenu Link Color','CURLYTHEME'),
				"id" => $shortname."_color_submenu_text",
				"class" => "split_three",
				"std" => "#33332E",
				"type" => "color");
	
	$options[] = array( "name" => __('Submenu Link Hover Color','CURLYTHEME'),
				"id" => $shortname."_color_submenu_hover_text",
				"class" => "split_three",
				"std" => "#c0392b",
				"type" => "color");
	
	$options[] = array( "name" => __('Submenu Bg. Color','CURLYTHEME'),
				"id" => $shortname."_color_menu_submenu",
				"class" => "split_three last",
				"std" => "#ffffff",
				"type" => "color");
	
	$options[] = array( "name" => __('Footer Color','CURLYTHEME'),
				"desc" => "",
				"id" => $shortname."_inf",
				"std" => "Footer Colors",
				"type" => "info");
	
	$options[] = array( "name" => __('Footer Text Color','CURLYTHEME'),
				"id" => $shortname."_footer_text_color",
				"class" => "split_three",
				"std" => "#9C9996",
				"type" => "color");
	
	$options[] = array( "name" => __('Footer Link Color','CURLYTHEME'),
				"id" => $shortname."_footer_link_color",
				"class" => "split_three last",
				"std" => "#9C9996",
				"type" => "color");
	
	$options[] = array( "name" => __('Footer Titles Color','CURLYTHEME'),
				"id" => $shortname."_footer_title_color",
				"class" => "split_three",
				"std" => "#FFFFFF",
				"type" => "color");

/*	Page Heading
	================================================= */
																				
	$options[] = array( "name" => __('Page Heading','CURLYTHEME'),
						"type" => "heading");												
				
	$options[] = array( "name" => __('Enable Breadcrumbs','CURLYTHEME'),
				"id" => $shortname."_bc",
				"desc" => __('Check this to enable the default theme breadcrumbs','CURLYTHEME'),
				"class" => "",
				"std" => true,
				"type" => "checkbox");	
	
	$options[] = array( "name" => __('Text Before Breadcrumbs','CURLYTHEME'),
				"id" => $shortname."_bc_text_before",
				"class" => "split_50 section_clear_left",
				"std" => "",
				"type" => "text");	
	
	$options[] = array( "name" => __('Breadcrumbs Separator','CURLYTHEME'),
				"id" => $shortname."_bc_separator",
				"class" => "split_50 split_right",
				"std" => "&nbsp;&nbsp;/&nbsp;&nbsp;",
				"type" => "text");				
				
	$options[] = array( "name" => __('Home Link Text','CURLYTHEME'),
				"id" => $shortname."_bc_text_home",
				"class" => "split_50",
				"std" => "Home",
				"type" => "text");	
	
	$options[] = array( "name" => __('Category Text','CURLYTHEME'),
				"id" => $shortname."_bc_text_category",
				"class" => "split_50 split_right",
				"std" => "Archive by Category '%s'",
				"type" => "text");	
	
	$options[] = array( "name" => __('Search Text','CURLYTHEME'),
				"id" => $shortname."_bc_text_search",
				"class" => "split_50",
				"std" => "Search Results for '%s' Query",
				"type" => "text");
	
	$options[] = array( "name" => __('Tag Text','CURLYTHEME'),
				"class" => "split_50 split_right",
				"id" => $shortname."_bc_text_tag",
				"std" => "Posts Tagged '%s'",
				"type" => "text");		
	
	$options[] = array( "name" => __(' Author Text','CURLYTHEME'),
				"class" => "split_50",
				"id" => $shortname."_bc_text_author",
				"std" => "Articles Posted by '%s'",
				"type" => "text");	
	
	$options[] = array( "name" => __('404 Page Text','CURLYTHEME'),
				"class" => "split_50 split_right",
				"id" => $shortname."_bc_text_404",
				"std" => "Error 404",
				"type" => "text");	
			
/*	Blog
	================================================= */
	
	$options[] = array( "name" => __('Blog','CURLYTHEME'),
						"type" => "heading");			
	
	$options[] = array( "name" => __('Description Excerpt Size','CURLYTHEME'),
				"desc" => "Enter the number of words you want to display",
				"id" => $shortname."_blog_listing_excerpt",
				"class" => "split_50",
				"std" => "20",
				"type" => "text");
	
	$options[] = array( "name" => __('Date Format','CURLYTHEME'),
				"desc" => __("Choose the date format. <a href='http://codex.wordpress.org/Formatting_Date_and_Time' target='_blank'>Date Formatting</a>", 'CURLYTHEME'),
				"id" => $shortname."_blog_date_format",
				"class" => "split_50 split_right",
				"std" => "F jS, Y",
				"type" => "text");
	
	$options[] = array( "name" => __('Show Featured Image','CURLYTHEME'),
				"desc" => __('Check this to show the featured image','CURLYTHEME'),
				"id" => $shortname."_blog_single_image",
				"class" => "split_50",
				"std" => "true",
				"type" => "checkbox");	
				
	
	$options[] = array( "name" => __('Hide Sharing Box ','CURLYTHEME'),
				"desc" => __("Check this to hide the sharing box", 'CURLYTHEME'),
				"id" => $shortname."_general_sharing_box",
				"class" => "split_50 split_right",
				"std" => "false",
				"type" => "checkbox");	
					
	$options[] = array( "name" => __('Hide Author Box','CURLYTHEME'),
				"desc" => __("Check this to hide the author box", 'CURLYTHEME'),
				"id" => $shortname."_hide_author",
				"class" => "split_50",
				"std" => "false",
				"type" => "checkbox");
				
	$options[] = array( "name" => __('Use Facebook Comments','CURLYTHEME'),
				"desc" => __('Check this if you want to replace the classic Wordpress Comments with Facebook Comments','CURLYTHEME'),
				"id" => $shortname."_fb_comments",
				"class" => "split_50 split_right",
				"std" => "false",
				"type" => "checkbox");
	
	$options[] = array( "name" => __('Facebook Profile ID','CURLYTHEME'),
				"desc" => "Enter your Facebook User ID. <br><a href='http://findmyfacebookid.com/' target='_blank'>Find your FB User ID</a>",
				"id" => $shortname."_fb_id",
				"std" => "",
				"type" => "text");					


/*	SEO
	================================================= */	

	$options[] = array( "name" => __('SEO Pro Panel','CURLYTHEME'),
						"type" => "heading");
	
	$options[] = array( "name" => __('Disable the Built-in SEO','CURLYTHEME'),
				"desc" => __('Disable the built-in SEO','CURLYTHEME'),
				"id" => $shortname."_seo",
				"class" => "split_50",
				"std" => "false",
				"type" => "checkbox");		
	
	$options[] = array( "name" => __('Rewrite Titles','CURLYTHEME'),
				"desc" => __('Disable the built-in SEO','CURLYTHEME'),
				"id" => $shortname."_seo_title_rewrite",
				"class" => "split_50 split_right",
				"std" => "false",
				"type" => "checkbox");	
	
	$options[] = array( "name" => __('Post Title Format','CURLYTHEME'),
				"desc" => __('Choose the title format for the post pages','CURLYTHEME'),
				"id" => $shortname."_seo_title_post",
				"class" => "split_50",
				"std" => "1",
				"type" => "select",
				"options" => array('Post Title', 'Post Title | Blog Title', 'Post Title | Blog Description'));
	
	$options[] = array( "name" => __('Page Title Format','CURLYTHEME'),
				"desc" => __('Choose the title format for the pages','CURLYTHEME'),
				"id" => $shortname."_seo_title_page",
				"class" => "split_50 split_right",
				"std" => "1",
				"type" => "select",
				"options" => array('Page Title', 'Page Title | Blog Title', 'Page Title | Blog Description'));
	
	$options[] = array( "name" => __('Category Title Format','CURLYTHEME'),
				"desc" => __('Choose the title format for the categories pages','CURLYTHEME'),
				"id" => $shortname."_seo_title_category",
				"class" => "split_50",
				"std" => "1",
				"type" => "select",
				"options" => array('Category Title', 'Category Title | Blog Title', 'Category Title | Blog Description', 'Category Title | Category Description'));
	
	$options[] = array( "name" => __('Archive Title Format','CURLYTHEME'),
				"desc" => __('Choose the title format for the archive pages','CURLYTHEME'),
				"id" => $shortname."_seo_title_archive",
				"class" => "split_50 split_right",
				"std" => "1",
				"type" => "select",
				"options" => array('Date', 'Date | Blog Title', 'Date | Blog Description'));
	
	$options[] = array( "name" => __('Tag Title Format','CURLYTHEME'),
				"desc" => __('Choose the title format for the tag pages','CURLYTHEME'),
				"id" => $shortname."_seo_title_tag",
				"class" => "split_50",
				"std" => "1",
				"type" => "select",
				"options" => array('Tag', 'Tag | Blog Title', 'Tag | Blog Description'));
	
	$options[] = array( "name" => __('Search Title Format','CURLYTHEME'),
				"desc" => __('Choose the title format for the search page','CURLYTHEME'),
				"id" => $shortname."_seo_title_search",
				"class" => "split_50 split_right",
				"std" => "1",
				"type" => "select",
				"options" => array('Search', 'Search | Blog Title', 'Search | Blog Description'));
	
	$options[] = array( "name" => __('404 Page Title Format','CURLYTHEME'),
				"desc" => __('Choose the title format for the 404 page','CURLYTHEME'),
				"id" => $shortname."_seo_title_search",
				"std" => "The page you are looking for, could not be found",
				"type" => "text");
	
	
	$options[] = array( "name" => __('Google Plus Publisher ID','CURLYTHEME'),
				"desc" => __('Enter the Google Plus Publisher ID','CURLYTHEME'),
				"id" => $shortname."_seo_publisher",
				"std" => "",
				"type" => "text");	
				
	$options[] = array( "name" => __('Google Analytics ID','CURLYTHEME'),
				"desc" => __('Enter the Google Analytics ID. <br> UA-XXXXX-Y or UA-XXXXX-YY.','CURLYTHEME'),
				"id" => $shortname."_seo_analytics",
				"std" => "",
				"type" => "text");	
	
	$options[] = array( "name" => __('Google Webmaster Tools Site Verification','CURLYTHEME'),
				"desc" => __('Please insert verification code for Webmaster tools in here','CURLYTHEME'),
				"id" => $shortname."_seo_webmaster",
				"std" => "",
				"type" => "text");
			
/*	More Options
	================================================= */	

	$options[] = array( "name" => __('More Options','CURLYTHEME'),
						"type" => "heading");			
	
	$options[] = array( "name" => __('Retina Logo','CURLYTHEME'),
				"desc" => __('Be sure that this complies with the retina standards','CURLYTHEME'),
				"id" => $shortname."_logo_retina",
				"std" => $defurl.'equestrian-logo@2x.png',
				"type" => "upload");
	
	$options[] = array( "name" => __('iPhone Retina Icon Upload','CURLYTHEME'),
				"desc" => __("Upload 114px * 114px icon", 'CURLYTHEME'),
				"id" => $shortname."_general_iphone_favicon_retina",
				"class" => "split_50",
				"std" => $defurl.'equestrian-iphone-114.png',
				"type" => "upload");						
							
	$options[] = array( "name" => __('iPhone Icon Upload','CURLYTHEME'),
					"desc" => __("Upload 57px * 57px icon", 'CURLYTHEME'),
					"id" => $shortname."_general_iphone_favicon",
					'class' => 'split_50 last',
					"std" => $defurl.'equestrian-iphone-57.png',
					"type" => "upload");			
	
	$options[] = array( "name" => __('iPad Retina Icon Upload','CURLYTHEME'),
				"desc" => __("Upload 144px * 144px icon.", 'CURLYTHEME'),
				"id" => $shortname."_general_ipad_favicon_retina",
				"class" => "split_50 section_clear_left",
				"std" => $defurl.'equestrian-ipad-144.png',
				"type" => "upload");				
	
	$options[] = array( "name" => __('iPad Icon Upload','CURLYTHEME'),
					"desc" => __("Upload 72px * 72px icon", 'CURLYTHEME'),
					"id" => $shortname."_general_ipad_favicon",
					'class' => 'split_50 split_right',
					"std" => $defurl.'equestrian-ipad-72.png',
					"type" => "upload");									
	
	$options[] = array( "name" => __('Additional Code','CURLYTHEME'),
				"desc" => "",
				"id" => $shortname."_inf",
				"std" => "Aditional Code",
				"type" => "info");				
	
	$options[] = array( "name" => __('Custom CSS','CURLYTHEME'),
				"id" => $shortname."_custom_css",
				'class' => 'full_textarea',
				"std" => "",
				"type" => "textarea");
	
	$options[] = array( "name" => __('Code before closing head','CURLYTHEME'),
				"id" => $shortname."_custom_head",
				'class' => 'full_textarea',
				"std" => "",
				"type" => "textarea");		
	
	$options[] = array( "name" => __('Code before closing body','CURLYTHEME'),
				"id" => $shortname."_custom_body",
				'class' => 'full_textarea',
				"std" => "",
				"type" => "textarea");									
								
update_option('of_template',$options); 					  
update_option('of_themename',$themename);   
update_option('of_shortname',$shortname);

}
}
?>